<?php
  BEvent::Hook('normalize comment', array('Antispam', 'Check'));
  BEvent::Hook('on tpl vars: common', array('Antispam', 'AddHeadScriptTo'));
  BEvent::Hook('on tpl vars: commenting', array('Antispam', 'AddFieldTo'));

  BConfig::$strings += array('antispam: caption' => 'Humans! Please enter "%s" here:',
                             'antispam: legend' => '(or turn JavaScript on for automatic verification)');

/* one-shot */
  $this->name = 'antispam';
  $this->Caption('Антиспам', 'ru');
/* install Antispam */
class Antispam {
  const Phrase = 'J';
  static $lastInputIndex = 0;

  static function Check($parent, $comment, &$info) {
    if (mb_strtolower($info['antispam']) !== mb_strtolower(self::Phrase)) {
      throw new BException('Antispam phrase error - please enter "'.self::Phrase.'".');
    }
  }

  static function AddFieldTo(&$vars, $varPrefix) {
    $index = ++self::$lastInputIndex;
    $legend = Translate('antispam: legend');

    $value = <<<HTML
  <input type="text" name="antispam" id="antispam$index" /> $legend
  <script type="text/javascript">
    HideAntispam( document.getElementById('antispam$index') );
  </script>
HTML;

    $vars[$varPrefix.'Fields'][] =
      array('type' => 'captcha', 'value' => $value,
            'caption' => Translate('antispam: caption', self::Phrase));
  }

  static function AddHeadScriptTo(&$vars) {
    $phrase = addslashes(Antispam::Phrase);
    $vars['headFooter'] .= <<<HTML
  <script type="text/javascript">
    function HideAntispam(input) {
      input.value = '$phrase';

      var parent = input.parentNode;
      var tries = 6;
      while (parent != null && tries-- > 0) {
        if (parent.nodeType == 1 && parent.tagName.toLowerCase() == 'tr') {
          parent.style.display = 'none';
          break;
        } else {
          parent = parent.parentNode;
        }
      }
    }
  </script>
HTML;
  }
}
